/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagriculture.handler;

import com.blakebr0.cucumber.helper.ColorHelper;
import com.blakebr0.cucumber.iface.IColored;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalagriculture.api.util.MobSoulUtils;
import com.blakebr0.mysticalagriculture.block.InfusedFarmlandBlock;
import com.blakebr0.mysticalagriculture.init.ModItems;
import com.blakebr0.mysticalagriculture.lib.ModCrops;
import com.blakebr0.mysticalagriculture.registry.AugmentRegistry;
import com.blakebr0.mysticalagriculture.registry.CropRegistry;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ColorHandler {
    @SubscribeEvent
    public void onBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.m_92589_((BlockColor)new IColored.BlockColors(), (Block[])InfusedFarmlandBlock.FARMLANDS.toArray(new InfusedFarmlandBlock[0]));
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            if (crop.isFlowerColored() && crop.getCropBlock() != null) {
                colors.m_92589_((state, world, pos, tint) -> crop.getFlowerColor(), new Block[]{crop.getCropBlock()});
            }
        });
    }

    @SubscribeEvent
    public void onItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        colors.m_92689_((ItemColor)new IColored.ItemBlockColors(), (ItemLike[])InfusedFarmlandBlock.FARMLANDS.toArray(new InfusedFarmlandBlock[0]));
        colors.m_92689_((stack, tint) -> {
            float damage = (float)(stack.m_41776_() - stack.m_41773_()) / (float)stack.m_41776_();
            return ColorHelper.saturate((int)55769, (float)damage);
        }, new ItemLike[]{(ItemLike)ModItems.INFUSION_CRYSTAL.get()});
        colors.m_92689_((stack, tint) -> ModCrops.AIR.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.AIR_AGGLOMERATIO.get()});
        colors.m_92689_((stack, tint) -> ModCrops.EARTH.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.EARTH_AGGLOMERATIO.get()});
        colors.m_92689_((stack, tint) -> ModCrops.WATER.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.WATER_AGGLOMERATIO.get()});
        colors.m_92689_((stack, tint) -> ModCrops.FIRE.getEssenceColor(), new ItemLike[]{(ItemLike)ModItems.FIRE_AGGLOMERATIO.get()});
        colors.m_92689_((stack, tint) -> {
            MobSoulType type = MobSoulUtils.getType(stack);
            return tint == 1 && type != null ? type.getColor() : -1;
        }, new ItemLike[]{(ItemLike)ModItems.SOUL_JAR.get()});
        CropRegistry.getInstance().getCrops().forEach(crop -> {
            if (crop.isEssenceColored() && crop.getEssenceItem() != null) {
                colors.m_92689_((stack, tint) -> crop.getEssenceColor(), new ItemLike[]{crop.getEssenceItem()});
            }
            if (crop.isSeedColored() && crop.getSeedsItem() != null) {
                colors.m_92689_((stack, tint) -> crop.getSeedColor(), new ItemLike[]{crop.getSeedsItem()});
            }
        });
        AugmentRegistry.getInstance().getAugments().forEach(augment -> {
            if (augment.getItem() != null) {
                colors.m_92689_((stack, tint) -> tint == 0 ? augment.getSecondaryColor() : (tint == 1 ? augment.getPrimaryColor() : -1), new ItemLike[]{augment.getItem()});
            }
        });
    }
}

